<?php 	

include_once("config.php");
include_once("authenticate.php");

if (isset($_POST["submit_button"])) {

	$error = 0;

	$old_password = isset($_POST["old_password"]) ? trim($_POST["old_password"]) : "";
	$new_password1 = isset($_POST["new_password1"]) ? trim($_POST["new_password1"]) : "";
	$new_password2 = isset($_POST["new_password2"]) ? trim($_POST["new_password2"]) : "";

	if (empty($old_password) || empty($new_password1) || empty($new_password2)) {
		$message = MSG_REQUIRED_INFO;
		$error = 1;
	}

	$file_handler = fopen(LOGIN_INFO_FILE, "r");
	if (!$file_handler) {
		$message = MSG_LOGIN_FILE_READ;
		$error = 1;
	} else {
		$file_data = fread($file_handler, filesize(LOGIN_INFO_FILE));
		fclose($file_handler);
		
		$login_info = explode("|", $file_data);
		$stored_username = isset($login_info[0]) ? trim($login_info[0]) : "";
		$stored_password = isset($login_info[1]) ? trim($login_info[1]) : "";

		if ($new_password1 != $new_password2) {
			$message = MSG_RETYPED_PASSWORD;
			$error = 1;
		} else if (strlen($new_password1) < PASSWORD_MIN_LENGTH) {
			$message = MSG_PASSWORD_MIN_LENGTH;
			$error = 1;
		} else if (!password_verify($old_password, $stored_password)) {
			$message = MSG_OLD_PASSWORD;
			$error = 1;
		}
	}

	if ($error == 0) {
		$new_password_hash = password_hash($new_password1, PASSWORD_DEFAULT);
		$updated_file_data = $stored_username . "|" . $new_password_hash;
		$file_handler = fopen(LOGIN_INFO_FILE, "w");
		if (!$file_handler) {
			$message = MSG_LOGIN_FILE_WRITE;
		} else {
			fwrite($file_handler, $updated_file_data);
			fclose($file_handler);			
			$message = MSG_PASSWORD_UPDATED;
			unset($old_password);
			unset($new_password1);
			unset($new_password2);
		}
	}
}

?>

<!doctype html>
<html>
<head>
	<title>Change password</title>
</head>
<body>
	
	<h3>Change password</h3>
	
	<?php if (isset($message)) print $message; ?>
	
	<form method="post" action="change_password.php">
		<br>
		Old password<br>
		<input type="password" id="old_password" name="old_password" 
			value="<?php if (isset($old_password)) print $old_password; ?>" required autofocus><br><br>

		New password<br>
		<input type="password" id="new_password1" name="new_password1" 
			value="<?php if (isset($new_password1)) print $new_password1; ?>" required><br><br>

		Retype new password<br>
		<input type="password" id="new_password2" name="new_password2" 
			value="<?php if (isset($new_password2)) print $new_password2; ?>" required><br><br>

		<input type="submit" name="submit_button" value="Update">
	</form>
	
	<p><a href="index.php">User profile</a></p>

</body>
</html>
