<?php 	

include_once("config.php");

if (isset($_POST["submit_button"])) {
	
	$error = 0;

	$username = isset($_POST["username"]) ? trim($_POST["username"]) : "";
	$password = isset($_POST["password"]) ? trim($_POST["password"]) : "";
	if (empty($username) || empty($password)) {
		$message = MSG_REQUIRED_INFO;
		$error = 1;
	}

	$file_handler = fopen(LOGIN_INFO_FILE, "r");
	if (!$file_handler) {
		$message = MSG_LOGIN_FILE_READ;
		$error = 1;
	} else {
		$file_data = fread($file_handler, filesize(LOGIN_INFO_FILE));
		fclose($file_handler);
		$login_info = explode("|", $file_data);
		$stored_username = isset($login_info[0]) ? trim($login_info[0]) : "";
		$stored_password = isset($login_info[1]) ? trim($login_info[1]) : "";
		if ($username != $stored_username || !password_verify($password, $stored_password)) {
			$message = MSG_INVALID_LOGIN;
			$error = 1;
		}
	}

	if ($error == 0) {
		session_start();
		$_SESSION["loggedin"] = true;
		header("Location: index.php");
		exit;
	}

}
?>

<!doctype html>
<html>
<head>
	<title>Login</title>
</head>
<body>
	
	<h3>Login</h3>
	
	<?php if (isset($message)) print $message; ?>
	
	<br>
	
	<form method="post" action="login.php">

		Username<br>
		<input type="text" id="username" name="username" value="<?php if (isset($username)) print $username; ?>" autofocus required><br><br>
	
		Password<br>
		<input type="password" id="password" name="password" value="<?php if (isset($password)) print $password; ?>" required><br><br>

		<input type="submit" name="submit_button" value="Login">

	</form>

</body>
</html>
